import bpy
import json
from os import path
from os.path import join
from bpy.types import PropertyGroup
from bpy.props import PointerProperty, EnumProperty, BoolProperty
from .props_toggles import FLUIDLAB_PG_toggles
# from ...addon.naming import FluidLabNaming
from ...libs.functions.get_common_vars import get_common_vars


class UiProps(PropertyGroup):

    """ context.scene.fluidlab.ui.x """

    # MAIN MODULES ----------------------------------------------------------------------------------

    collapse_module_selector: BoolProperty(default=False)

    @staticmethod
    def main_modules_update(self, context):
        # para mantenerlos ambos sincronizados:
        if self.main_modules_collapsed != self.main_modules:
            self.main_modules_collapsed = self.main_modules
        
        if self.main_modules == 'SHADING':
            fluidlab = get_common_vars(context, get_fluidlab=True)
            
            # Si no hay miniaturas las cargamos:
            if len(fluidlab.shader_props.enum_items) == 0:
                fluidlab.shader_props.get_thumbnails_items(context, rescan=True)

    # Nombre del archivo JSON que deseas leer
    input_file = join(path.dirname(__file__), "main_modules.json") # el orden de los items en el json da igual.

    # Leer los datos desde el archivo JSON
    with open(input_file, 'r') as file:
        global json_data
        json_data = json.load(file)

    # Ordenamos los items para cada Enum:
    order_module_item = (
                                    'FLUID_SETTINGS', 
                                    'FLUID_PRESETS', 
                                    'FORCES', 
                                    'COLLIDERS', 
                                    'EXPORT_IMPORT', 
                                    'FLUID_INTERACTIONS', 
                                    'MESH', 
                                    'DYNAMIC_PAINT', 
                                    'SHADING', 
                                    'RENDERING'
    )
    order_module_item_collapsed = (
                                    'FLUID_SETTINGS', 
                                    'FORCES', 
                                    'FLUID_PRESETS', 
                                    'COLLIDERS', 
                                    'EXPORT_IMPORT', 
                                    'FLUID_INTERACTIONS', 
                                    'MESH', 
                                    'DYNAMIC_PAINT', 
                                    'SHADING', 
                                    'RENDERING'
    )
    module_items = [(slug, json_data[slug]['label'], json_data[slug]['description'], json_data[slug]['icon'], i) for i, slug in enumerate(order_module_item)]
    module_items_collapsed = [(slug, json_data[slug]['label'], json_data[slug]['description'], json_data[slug]['icon'], i) for i, slug in enumerate(order_module_item_collapsed)]

    # para setear lo mismo en ambos enums:
    main_modules_name = "Main Modules"
    main_modules_description = "Main areas of work"
    main_modules_default = 'FLUID_SETTINGS'

    main_modules: EnumProperty(
        items=module_items,
        name=main_modules_name,
        description=main_modules_description,
        default=main_modules_default,
        update=lambda self, context: self.main_modules_update(self, context)
    )

    @staticmethod
    def main_modules_collapsed_update(self, context):
        # para mantenerlos ambos sincronizados:
        if self.main_modules != self.main_modules_collapsed:
            self.main_modules = self.main_modules_collapsed

    main_modules_collapsed: EnumProperty(
        items=module_items_collapsed,
        name=main_modules_name,
        description=main_modules_description,
        default=main_modules_default,
        update=lambda self, context: self.main_modules_collapsed_update(self, context)
    )
    # END MAIN MODULES ------------------------------------------------------------------------------


    # Para los collapsables -------------------------------------------------------------------------
    toggles: PointerProperty(type=FLUIDLAB_PG_toggles)

    # Los modos Basic/Advanced ----------------------------------------------------------------------
    ui_mode: EnumProperty(
        items=(
            ('BASIC',       "Basic",    "Basic Mode",        0),
            ('ADVANCED',    "Advanced", "Advanced Mode",    1),
        ),
        # default='BASIC'
        default='ADVANCED'

    )

    # ui generic/global properties ------------------------------------------------------------------ 
    fake_button: BoolProperty(default=False)

    # panel Rendering sections:
    rendering_subsections: EnumProperty(
        name="Render Sections",
        description="switching between types of working with viewport/rendering",
        items=(
            ('VIEWPORT',    "Viewport", "", 0),
            ('RENDER',      "Render",   "", 1),
            ('WORLD',       "World",    "", 2),
        ),
        default='VIEWPORT',
    )

    # Panel del module Export/Imports:
    hide_original_mesh: BoolProperty(default=True)
    auto_import: BoolProperty(default=True)